<?php

class Thim_List_Event_Widget extends Thim_Widget {

	function __construct() {
		parent::__construct(
			'list-event',
			esc_html__( 'Thim: List Events ', 'coaching' ),
			array(
				'description'   => esc_html__( 'Display list events', 'coaching' ),
				'help'          => '',
				'panels_groups' => array( 'thim_widget_group' ),
			),
			array(),
			array(
				'title'         => array(
					'type'                  => 'text',
					'label'                 => esc_html__( 'Title', 'coaching' ),
					'allow_html_formatting' => true
				),
				'layout'        => array(
					'type'    => 'select',
					'label'   => esc_html__( 'Layout', 'coaching' ),
					'options' => array(
						'base'     => esc_html__( 'Default', 'coaching' ),
						'layout-2' => esc_html__( 'Layout 2', 'coaching' ),
					),
					'default' => 'base'
				),
				'number_posts'  => array(
					'type'    => 'number',
					'label'   => esc_html__( 'Number posts', 'coaching' ),
					'default' => '2'
				),
				'feature_items' => array(
					'type'    => 'number',
					'label'   => esc_html__( 'Feature Items', 'coaching' ),
					'default' => '1'
				),
				'text_link'     => array(
					'type'                  => 'text',
					'label'                 => esc_html__( 'Text Link All', 'coaching' ),
					'default'               => esc_html__( 'View All', 'coaching' ),
					'allow_html_formatting' => true
				),

			),
			THIM_DIR . 'inc/widgets/list-event/'
		);
	}

	/**
	 * Initialize the CTA widget
	 */

	function get_template_name( $instance ) {
		if ( isset( $instance['layout'] ) && $instance['layout'] == 'layout-2' ) {
			return $instance['layout'];
		} else {
			return 'base';
		}

	}

	function get_style_name( $instance ) {
		return false;
	}
}

function thim_list_event_widget() {
	register_widget( 'Thim_List_Event_Widget' );
}

add_action( 'widgets_init', 'thim_list_event_widget' );