<?php

$number_posts = $instance['number_posts'] ? $instance['number_posts'] : 10;
$feature_item = $instance['feature_items'] ? $instance['feature_items'] : 1;

$link       = get_post_type_archive_link( 'tp_event' );
$query_args = array(
	'post_type'           => 'tp_event',
	'posts_per_page'      => - 1,
	'post_status'         => array( 'tp-event-happenning', 'tp-event-upcoming' ),
	'ignore_sticky_posts' => true
);

$events  = new WP_Query( $query_args );
$html    = array();
$sorting = array();

if ( $events->have_posts() ) {
	if ( $instance['title'] ) {
		echo ent2ncr( $args['before_title'] . $instance['title'] . $args['after_title'] );
	}
	echo '<div class="thim-list-event">';

	while ( $events->have_posts() ) {

		$events->the_post();

		$sorting[ strtotime( tp_event_get_time() ) ] = get_the_ID();

		$html[ get_the_ID() ]['class']      = join( ' ', get_post_class( 'item-event', get_the_ID() ) );
		$html[ get_the_ID() ]['time_from']  = tp_event_start( 'g:i A' );
		$html[ get_the_ID() ]['time_end']   = tp_event_end( 'g:i A' );
		$html[ get_the_ID() ]['location']   = tp_event_location();
		$html[ get_the_ID() ]['date_show']  = tp_event_get_time( 'd' );
		$html[ get_the_ID() ]['month_show'] = tp_event_get_time( 'M' );
		$html[ get_the_ID() ]['title']      = get_the_title();
		$html[ get_the_ID() ]['url']        = get_permalink( get_the_ID() );
		$html[ get_the_ID() ]['image_id']   = get_post_thumbnail_id();
		$html[ get_the_ID() ]['excerpt']    = thim_excerpt( 35 );

	}

	ksort( $sorting );

	if ( ! empty( $sorting ) ) {
		$index = 1;
		foreach ( $sorting as $value ) {
			if ( $index > $number_posts ) {
				break;
			}
			if ( $html[ $value ] ) {
				if ( $index <= $feature_item ) {
					?>
					<div class="<?php echo ent2ncr( $html[ $value ]['class'] ); ?> feature-item">
						<div class="image">
							<?php echo thim_get_feature_image( $html[ $value ]['image_id'], 'full', apply_filters( 'thim_event_thumbnail_width', 585 ), apply_filters( 'thim_event_thumbnail_height', 340 ) ); ?>
							<?php echo do_shortcode( '[tp_event_countdown events="' . $value . '"]' ); ?>
						</div>
						
						<div class="event-wrapper">

							<div class="time-from">
								<?php do_action( 'thim_before_event_time' ); ?>
								<div class="date">
									<?php echo esc_html( $html[ $value ]['date_show'] ); ?>
								</div>
								<div class="month">
									<?php echo esc_html( $html[ $value ]['month_show'] ); ?>
								</div>
								<?php do_action( 'thim_after_event_time' ); ?>
							</div>

							<div class="top-heading">
								<h5 class="title">
									<a href="<?php echo esc_url( $html[ $value ]['url'] ); ?>"> <?php echo esc_html( $html[ $value ]['title'] ) ; ?></a>
								</h5>

								<div class="meta">
									<div class="time">
										<i class="fa fa-clock-o"></i>
										<?php echo esc_html( $html[ $value ]['time_from'] ) . ' - ' . esc_html( $html[ $value ]['time_end'] ); ?>
									</div>
									<div class="location">
										<i class="fa fa-map-marker"></i>
										<?php echo ent2ncr( $html[ $value ]['location'] ); ?>
									</div>
								</div>
							</div>

							<div class="description">
								<?php echo ent2ncr( $html[ $value ]['excerpt'] ); ?>
							</div>

							<div class="view-detail">
								<a class="thim-button" href="<?php echo esc_url( $html[ $value ]['url'] ); ?>"> <?php esc_html_e( 'View Detail', 'coaching' ); ?></a>
							</div>

						</div>
					</div>
					<?php
				} else {
					?>
					<div class="<?php echo ent2ncr( $html[ $value ]['class'] ); ?>">
						<div class="event-wrapper">
							<div class="time-from">
								<?php do_action( 'thim_before_event_time' ); ?>
								<div class="date">
									<?php echo esc_html( $html[ $value ]['date_show'] ); ?>
								</div>
								<div class="month">
									<?php echo esc_html( $html[ $value ]['month_show'] ); ?>
								</div>
								<?php do_action( 'thim_after_event_time' ); ?>
							</div>
							<div class="top-heading">
								<h5 class="title">
									<a href="<?php echo esc_url( $html[ $value ]['url'] ); ?>"> <?php echo esc_html( $html[ $value ]['title'] ); ?></a>
								</h5>

								<div class="meta">
									<div class="time">
										<i class="fa fa-clock-o"></i>
										<?php echo esc_html( $html[ $value ]['time_from'] ) . ' - ' . esc_html( $html[ $value ]['time_end'] ); ?>
									</div>
									<div class="location">
										<i class="fa fa-map-marker"></i>
										<?php echo ent2ncr( $html[ $value ]['location'] ); ?>
									</div>
								</div>
							</div>
							<div class="view-detail">
								<a class="thim-button" href="<?php echo esc_url( $html[ $value ]['url'] ); ?>"> <?php esc_html_e( 'View Detail', 'coaching' ); ?></a>
							</div>
						</div>
					</div>
					<?php
				}
			}
			$index ++;
		}
	}
	if ( $instance['text_link'] <> '' ) {
		echo '<div class="view-all"><a class="view-all-link thim-button" href="' . esc_url( $link ) . '">' . $instance['text_link'] . '</a></div>';
	}
	echo '</div>';
}

wp_reset_postdata();

?>
