<?php

class Thim_Slider_Widget extends Thim_Widget {
	function __construct() {
		parent::__construct(
			'slider',
			esc_html__( 'Thim: Slider', 'coaching' ),
			array(
				'description'   => esc_html__( 'Thim Slider', 'coaching' ),
				'help'          => '',
				'panels_groups' => array( 'thim_widget_group' ),
				'panels_icon' => 'dashicons dashicons-welcome-learn-more'
			),
			array(),
			array(
				'thim_slider_frames'  => array(
					'type'      => 'repeater',
					'label'     => esc_html__( 'Slider Frames', 'coaching' ),
					'item_name' => esc_html__( 'Frame', 'coaching' ),
					'fields'    => array(
						'thim_slider_background_image' => array(
							'type'    => 'media',
							'library' => 'image',
							'label'   => esc_html__( 'Background Image', 'coaching' ),
						),
						'color_overlay'                => array(
							'type'  => 'color',
							'label' => esc_html__( 'Color Overlay images', 'coaching' ),
						),
						'content'                      => array(
							'type'   => 'section',
							'label'  => esc_html__( 'Content Slider', 'coaching'),
							'hide'   => true,
							'fields' => array(
								'thim_slider_icon'        => array(
									'type'    => 'media',
									'library' => 'image',
									'label'   => esc_html__( 'Icon', 'coaching' ),
								),
								'thim_slider_title'       => array(
									'type'                  => 'text',
									'label'                 => esc_html__( 'Heading Slider', 'coaching' ),
									'allow_html_formatting' => true,
								),
								'size'                    => array(
									'type'        => 'number',
									'label'       => esc_html__( 'Custom Font Size Title', 'coaching' ),
									'description' => 'input custom font size: ex: 30',
									'class'       => 'color-mini',
								),
								'thim_color_title'        => array(
									'type'  => 'color',
									'label' => esc_html__( 'Heading Color Title', 'coaching' ),
									'class' => 'color-mini',
								),
								'line-bottom'             => array(
									'type'    => 'checkbox',
									'label'   => esc_html__( 'line bottom', 'coaching' ),
									'default' => false,
									'class'   => 'color-mini',
								),
								'thim_slider_description' => array(
									'type'                  => 'textarea',
									'label'                 => esc_html__( 'Description', 'coaching' ),
									'allow_html_formatting' => true,
									'class'                 => 'clear-both',
								),
								'thim_color_des'          => array(
									'type'  => 'color',
									'label' => esc_html__( 'Description Color', 'coaching' )
								),
								'thim_slider_align'       => array(
									'type'    => 'select',
									'label'   => esc_html__( 'Content Align:', 'coaching' ),
									'options' => array(
										'left'   => esc_html__( 'Left', 'coaching' ),
										'right'  => esc_html__( 'Right', 'coaching' ),
										'center' => esc_html__( 'Center', 'coaching' )
									),
								),
							),
						),
					),
				),
				'thim_slider_speed'   => array(
					'type'        => 'number',
					'label'       => esc_html__( 'Animation Speed', 'coaching' ),
					'description' => esc_html__( 'Animation speed in milliseconds.', 'coaching' ),
					'default'     => 800,
				),
				'thim_slider_timeout' => array(
					'type'        => 'number',
					'label'       => esc_html__( 'Timeout', 'coaching' ),
					'description' => esc_html__( 'How long each slide is displayed for in milliseconds.', 'coaching' ),
					'default'     => 8000,
				),
				'slider_full_screen'  => array(
					'type'    => 'checkbox',
					'label'   => esc_html__( 'Full Screen', 'coaching' ),
					'default' => false ),
				'show_icon_scroll'    => array(
					'type'          => 'radio',
					'label'         => esc_html__( 'Icon Scroll', 'coaching' ),
					'options'       => array(
						'show' => esc_html__( 'Show', 'coaching' ),
						'hide' => esc_html__( 'Hide', 'coaching' )
					),
					'default'       => 'hide',
					'state_emitter' => array(
						'callback' => 'select',
						'args'     => array( 'show_icon_scroll_type' )
					)
				),
				'text_before_btn'     => array(
					'type'          => 'text',
					'label'         => esc_html__( 'Text Before Arrow', 'coaching' ),
					'state_handler' => array(
						'show_icon_scroll_type[show]' => array( 'show' ),
						'show_icon_scroll_type[hide]' => array( 'hide' ),
					),
					'default'       => esc_html__( 'Getting started' , 'coaching')
				),
				'button_id'           => array(
					'type'          => 'text',
					'label'         => esc_html__( 'ID', 'coaching' ),
					'state_handler' => array(
						'show_icon_scroll_type[show]' => array( 'show' ),
						'show_icon_scroll_type[hide]' => array( 'hide' ),
					),
					'description'   => esc_html__( 'id section scoll', 'coaching' ),
				),
			),
			THIM_DIR . 'inc/widgets/slider/'
		);
	}

	function get_template_name( $instance ) {
		return 'base';
	}

	function get_style_name( $instance ) {
		return false;
	}

	/**
	 * Enqueue the slider scripts
	 */
	function enqueue_frontend_scripts() {
		wp_enqueue_script( 'thim-jquery-cycle', THIM_URI . 'inc/widgets/slider/js/jquery.cycle.min.js', array( 'jquery' ), '', true );
		wp_enqueue_script( 'thim-cycle.swipe', THIM_URI . 'inc/widgets/slider/js/jquery.cycle.swipe.min.js', array( 'jquery' ), '', true );
		wp_enqueue_script( 'thim-slider', THIM_URI . 'inc/widgets/slider/js/slider.js', array( 'jquery' ), '', true );
	}
}

function thim_slider_register_widget() {
	register_widget( 'Thim_Slider_Widget' );
}

add_action( 'widgets_init', 'thim_slider_register_widget' );