<?php
if ( class_exists( 'THIM_Testimonials' ) ) {
	class Thim_Testimonials_Widget extends Thim_Widget {
		function __construct() {
			parent::__construct(
				'testimonials',
				esc_html__( 'Thim: Testimonials', 'coaching' ),
				array(
					'description'   => esc_html__( '', 'coaching' ),
					'help'          => '',
					'panels_groups' => array( 'thim_widget_group' ),
					'panels_icon'   => 'dashicons dashicons-welcome-learn-more'
				),
				array(),
				array(
					'title'        => array(
						'type'                  => 'text',
						'label'                 => esc_html__( 'Heading Text', 'coaching' ),
						'default'               => esc_html__( 'Testimonials', 'coaching' ),
						'allow_html_formatting' => true
					),
					'layout'       => array(
						'type'    => 'select',
						'label'   => esc_html__( 'Layout', 'coaching' ),
						'default' => 'base',
						'options' => array(
							'base'         => esc_html__( 'Default', 'coaching' ),
							'layout_1'      => esc_html__('Testimonial Layout 1','coaching'),
							'before_after' => esc_html__( 'Before After Image', 'coaching' ),
						)
					),
					'limit'        => array(
						'type'    => 'number',
						'label'   => esc_html__( 'Limit Posts', 'coaching' ),
						'default' => '7'
					),
					'item_visible' => array(
						'type'    => 'number',
						'label'   => esc_html__( 'Visible items', 'coaching' ),
						'default' => '2'
					),
					'autoplay'     => array(
						'type'    => 'checkbox',
						'label'   => esc_html__( 'Auto play', 'coaching' ),
						'default' => false,
					),

				)
			);
		}

		/**
		 * Initialize the CTA widget
		 */


		function get_template_name( $instance ) {
			if ( !empty( $instance['layout'] ) ) {
				return $instance['layout'];
			}
			else {
				return 'base';
			}

		}

		function get_style_name( $instance ) {
			return false;
		}

		function enqueue_scripts() {
			
		}

	}

	function thim_testimonials_register_widget() {
		register_widget( 'Thim_Testimonials_Widget' );
	}

	add_action( 'widgets_init', 'thim_testimonials_register_widget' );
}