<?php
/**
 * @author        ThimPress
 * @package       LearnPress/Templates
 * @version       1.0
 */

defined( 'ABSPATH' ) || exit();

$user        = learn_press_get_current_user();
$course      = LP()->global['course'];
$item_status = $user->get_item_status( $item->ID );
$security    = wp_create_nonce( sprintf( 'complete-item-%d-%d-%d', $user->id, $course->id, $item->ID ) );
$course_item = $course->get_item( $item->ID );
$viewable    = learn_press_user_can_view_lesson( $item->ID, $course->id );

$is_enrolled      = $user->has_enrolled_course($course->id);
$require_enrolled = $course->is_require_enrollment();
?>

<?php do_action( 'learn_press_before_item_meta', $item ); ?>



<?php if ( $user->can_view_item( $item->ID, $course->id ) !== false ) { ?>
	<?php //if ( $item_status == 'completed' ) { ?>
	<span class="completed-button"><?php esc_attr_e( 'Completed', 'coaching' ); ?></span>
	<?php //} ?>
<?php } ?>

<?php if ( $item_status !== 'completed' && !$is_enrolled && $require_enrolled && $course_item->is_preview() ): ?>
	<a class="lesson-preview button-load-item" href="<?php echo $course->get_item_link( $item->ID ) ; ?>" data-id="<?php echo $item->ID; ?>" data-complete-nonce="<?php echo wp_create_nonce( 'learn-press-complete-' . $item->post_type . '-' . $item->ID ); ?>"><?php _e( 'Preview', 'coaching' ); ?></a>
<?php endif; ?>

<?php
if ( !$viewable ) {
	echo '<span class="locked">' . esc_html__( 'Locked', 'coaching' ) . '</span>';
}
?>
<?php if ( $item->post_type == 'lp_quiz' ) : ?>
	<span class="meta"><?php echo thim_quiz_questions( $item->ID ) . ' ' . esc_html__( 'questions', 'coaching' ); ?></span>
<?php else: ?>
	<span class="meta"><?php echo thim_lesson_duration( $item->ID ); ?></span>
<?php endif ?>

<?php do_action( 'learn_press_after_item_meta', $item ); ?>

