<?php
/**
 * @author        ThimPress
 * @package       LearnPress/Templates
 * @version       1.0
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>
<h2><?php esc_html_e( 'Order Details', 'coaching' ); ?></h2>
<table class="order_table order_details">
	<thead>
	<tr>
		<th class="course-name"><?php esc_html_e( 'Course', 'coaching' ); ?></th>
		<th class="course-total"><?php esc_html_e( 'Total', 'coaching' ); ?></th>
	</tr>
	</thead>
	<tbody>
	<?php
	if ( $items = $order->get_items() ) {
		$currency_symbol = learn_press_get_currency_symbol( $order->order_currency );

		foreach ( $items as $item_id => $item ) {
			//$_course  = apply_filters( 'learn_press_order_item_course', get_post( $item_id ), $item );
			if ( apply_filters( 'learn_press_order_item_visible', true, $item ) ) {
				?>
				<tr class="<?php echo esc_attr( apply_filters( 'learn_press_order_item_class', 'order_item', $item, $order ) ); ?>">
					<td class="course-name">
						<?php
						echo apply_filters( 'learn_press_order_item_name', sprintf( '<a href="%s">%s</a>', get_permalink( $item['course_id'] ), $item['name'] ), $item );
						?>
					</td>
					<td class="product-total">
						<?php echo !empty( $item['total'] ) ? learn_press_format_price( $item['total'], $currency_symbol ) : esc_html__( 'Free!', 'coaching' ); ?>
					</td>
				</tr>
				<?php
			}
		}
	}
	do_action( 'learn_press_order_items_table', $order );
	?>
	</tbody>
	<tfoot>

	<tr>
		<th scope="row"><?php esc_html_e( 'Subtotal', 'coaching' ); ?></th>
		<td><?php echo esc_html( $order->get_formatted_order_subtotal() ); ?></td>
	</tr>
	<tr>
		<th scope="row"><?php esc_html_e( 'Total', 'coaching' ); ?></th>
		<td><?php echo esc_html( $order->get_formatted_order_total() ); ?></td>
	</tr>
	</tfoot>
</table>

<?php do_action( 'learn_press_order_details_after_order_table', $order ); ?>

<div class="clear"></div>
