<?php
/**
 * Template for displaying the history for the quiz
 *
 * @author  ThimPress
 * @package LearnPress
 * @version 1.0
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $quiz;

if ( !$quiz->retake_count || !LP()->user->has( 'completed-quiz', $quiz->id ) ) {
	return;
}
$limit   = 10;
$history = LP()->user->get_quiz_history( $quiz->id );
reset( $history );

$history_count = sizeof( $history );
$view_id       = !empty( $_REQUEST['history_id'] ) ? $_REQUEST['history_id'] : key( $history );
$heading       = sprintf( esc_html__( 'Other results (newest %d items)', 'coaching' ), $limit );
$heading       = apply_filters( 'learn_press_list_questions_heading', $heading );
?>

<?php if ( $heading ) { ?>
	<h4 class="quiz-history-title"><?php echo esc_html( $heading ); ?></h4>
<?php } ?>

<?php
if ( $history_count > 1 ) {
	$position = 0;
	?>
	<table class="quiz-history">
		<thead>
		<tr>
			<th width="50" align="right">#</th>
			<th><?php esc_html_e( 'Time', 'coaching' ); ?></th>
			<th><?php esc_html_e( 'Result', 'coaching' ); ?></th>
		</tr>
		</thead>
		<?php foreach ( $history as $item ) {
			if ( $item->history_id == $view_id ) continue;
			$position ++; ?>
			<tr>
				<td align="right"><?php echo esc_html( $position ); ?></td>
				<td>
					<?php echo date( get_option( 'date_format' ), $item->start ); ?>
					<div><?php echo date( get_option( 'time_format' ), $item->start ); ?></div>
				</td>
				<td>
					<div style="display: none;">
						<?php echo esc_html( $item->results['mark'] ) . '/' . esc_html( $item->results['quiz_mark'] ); ?>
					</div>
					<?php if ( $item->results['quiz_mark'] ) { ?>
						<?php printf( "%01.2f (%%)", ( $item->results['mark'] / $item->results['quiz_mark'] ) * 100 ); ?>
					<?php } else { ?>
						<?php printf( "%01.2f (%%)", 0 ); ?>
					<?php } ?>
					<!--
				<p class="quiz-history-actions">
					<a href="<?php echo add_query_arg( 'history_id', $item->history_id ); ?>"><?php esc_html_e( 'View', 'coaching' ); ?></a>
					<a href=""><?php esc_html_e( 'Use as result', 'coaching' ); ?></a>
				</p>
				-->
				</td>
			</tr>
			<?php if ( $position >= $limit ) break;
		} ?>
	</table>
	<?php

} else {
	learn_press_display_message( esc_html__( 'No history found!', 'coaching' ), 'notice' );
}