<?php
/**
 * Single product short description
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/short-description.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $post;

if ( ! $post->post_excerpt ) return;
?>

<div itemprop="description" class="description">
	<?php
	if ( get_post_meta(get_the_ID(), 'thim_product_author', true)){
		echo '<div class="author_product">'. esc_html__('By: ','coaching').'<span>'. get_post_meta(get_the_ID(), 'thim_product_author', true).'</span></div>';
	}
	?>
	<?php
		$description = $post->post_excerpt;
		if(strlen($post->post_excerpt )>150){
			$description = substr($post->post_excerpt,0,149) . '... <a id="des-readmore-link">'.esc_html__('READ MORE','coaching').'</a>';
		}
	?>
 	<?php echo apply_filters( 'woocommerce_short_description', $description ) ?>
</div>