<?php

/*** Child Theme Function  ***/

if ( ! function_exists( 'pitch_qode_child_theme_enqueue_scripts' ) ) {
	function pitch_qode_child_theme_enqueue_scripts() {
		$parent_style = 'pitch-default-style';
		
		wp_enqueue_style( 'pitch-child-style', get_stylesheet_directory_uri() . '/style.css', array( $parent_style ) );
	}
	
	add_action( 'wp_enqueue_scripts', 'pitch_qode_child_theme_enqueue_scripts' );
}

add_filter( 'wp_sitemaps_enabled', '__return_false' );

/** 
 * Enables the HTTP Strict Transport Security (HSTS) header in WordPress. 
 */
function tg_enable_strict_transport_security_hsts_header_wordpress() {
    header( 'Strict-Transport-Security: max-age=31536000' );
}
add_action( 'send_headers', 'tg_enable_strict_transport_security_hsts_header_wordpress' );
